<?php

namespace Modules\Twitchstreams\Plugins;

use \Modules\Twitchstreams\Models\Streamer as StreamerModel;

class Streamer
{
    private $clientId = '';
    private $clientSecret = '';
    private $streamer = [];

    private $token = '';
    private $onlineStreamer = [];

    function __construct(string $clientId, string $clientSecret)
    {
        $this->clientId = $clientId;
        $this->clientSecret = $clientSecret;
    }

    public function loginTwitch()
    {
        if ($this->clientId && $this->clientSecret) {
            $ch = curl_init('https://id.twitch.tv/oauth2/token');
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            $fields = array(
                'client_id' => $this->clientId,
                'client_secret' => $this->clientSecret,
                'grant_type' => 'client_credentials',
                'token_type' => 'bearer'
            );
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            $output = curl_exec($ch);
            $oauth = json_decode($output, true);
            if (isset($oauth['access_token'])) {
                $this->token = $oauth['access_token'];
            } else {
                $this->token = '';
            }
        }
        return $this;
    }

    public function getOnlineStreamer()
    {
        $this->loginTwitch();
        if (count($this->streamer) > 0 && $this->token) {
            foreach ($this->streamer as $streamer) {
                $ch = curl_init('https://api.twitch.tv/helix/streams?user_login=' . $streamer->getUser());
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $this->token, 'Client-ID: ' . $this->clientId]);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                $data = curl_exec($ch);
                curl_close($ch);
                $allres = json_decode($data, true);

                if (isset($allres['data'])) {
                    foreach ($allres['data'] as $stream) {
                        $model = new StreamerModel();
                        $model->setUser($stream['user_name'])
                            ->setTitle($stream['title'])
                            ->setViewers($stream['viewer_count'])
                            ->setOnline($stream['type'] == 'live' ? true : false)
                            ->setPreviewMedium(str_replace('{width}x{height}', '1920x1080', $stream['thumbnail_url']))
                            ->setCreatedAt($stream['started_at']);

                        $model->setGame($stream['game_name']);

                        $this->onlineStreamer[] = $model;
                    }
                }
            }
            return $this->onlineStreamer;
        } else {
            return null;
        }

    }

    public function setStreamer($streamerArray)
    {
        if (is_array($streamerArray)) {
            $this->streamer = $streamerArray;
        }
        return $this;
    }

    public function addStreamer(string $streamer)
    {
        if ($streamer) {
            $this->streamer[] = $streamer;
        }
        return $this;
    }
}
